//---- INITIAL VARIABLES
_root.playheadInDrag = false;
_root.playState = "notLoaded"; //- values later: playing, paused, wasPlaying
_root.volumeInDrag = false;
_root.progressBarWidth = 386;
_root.progressBarStartX = 103;
_root.volumeBarWidth = 71;
_root.volumeBarStartX = 2;
_root.volumeMC.volumeSlider._x = _root.volumeBarStartX + _root.volumeBarWidth;
_root.frameSizeText._visible = false;
_root.fpsText._visible = false;
_root.progressText.text = "00:00 / 00:00";

_root.numberOfSamples = 20;
_root.samplesArray = new Array(_root.numberOfSamples);
_root.samplesIndex = 0;
_root.sampleLastTime = getTimer();
_root.previousTotalBytesLoaded = 0;
for (i = 0; i < _root.numberOfSamples; i++) {
    _root.samplesArray[i] = 0;
    //trace("set " + i + " value: " + _root.samplesArray[i]);
}



//---- VIDEO FUNCTIONS
// Load video function
_root.loadVideo = function (clipToLoad) {
    // New net connection and stream connection
    my_nc = new NetConnection();
    my_nc.connect(null);
    _root.netStream = new NetStream(my_nc);
    _root.netStream.setBufferTime(2);
    
    // Attach and play the video
    _root.videoContainer.attachVideo(_root.netStream);
    _root.netStream.play(clipToLoad);
    _root.playState = "playing";


    // Attach the audio to a new clip
    _root.createEmptyMovieClip("audio_mc", _root.getNextHighestDepth());
    _root.audio_mc.attachAudio(_root.netStream);
    _root.flv_audio = new Sound(audio_mc);
    _root.flv_audio.setVolume(100);

    // Extract the metadata
    _root.netStream.onMetaData = function(obj) {
        for (var propName in obj) {
            trace(propName + " = " + obj[propName]);
        }
        this.totalTime = obj.duration;
        _root.durationString = convertToMinutes(obj.duration);
        
        // Populate the more static of the dynamic fields
        var combinedRate = obj["videodatarate"] + obj["audiodatarate"];
        _root.rateText.text = "Stream rate: " + combinedRate + " kbps";
        _root.frameSizeText.text = obj["width"]+" x "+obj["height"];
    }

    // Save status
    _root.playState = "playing";
    
    // Set continual update
    _root.continualUpdate = setInterval(updateVideo, 100);
};

// Update video function
_root.updateVideo = function() {
    // Show amount loaded
    var amountLoaded = _root.netStream.bytesLoaded / _root.netStream.bytesTotal; //- A percentage; 0.0 to 1.0
    _root.loadBar._width = amountLoaded * _root.progressBarWidth;
    
    // Do sampling
    var currentTime = getTimer();
    var elapsedTime = currentTime - _root.sampleLastTime;
    _root.sampleLastTime = currentTime;
    var totalLoaded = _root.netStream.bytesLoaded;
    var newBytesLoaded = totalLoaded - _root.previousTotalBytesLoaded;
    _root.previousTotalBytesLoaded = totalLoaded;
    
    var currentRate = newBytesLoaded / (elapsedTime / 1000) * 8 / 1000; //- in kbps
    //trace("sampling: " + currentRate);
    //_root.testText.text = "And: " + int(currentRate);
    _root.streamSample(currentRate);
    _root.dlRateText.text = "Download rate: "+Math.round(_root.sampleAverage()).toString()+" kbps";
    
    // Update dynamic fields
    _root.fpsText.text = Math.round(_root.netStream.currentFps).toString() + "fps";
    if (_root.durationString != undefined) {
        _root.progressText.text = _root.convertToMinutes(_root.netStream.time) + " / " + _root.durationString;
    }

    // Move playhead if not dragging
    if (!_root.playheadInDrag) {
        var amountPlayed = _root.netStream.time / _root.netStream.totalTime;
        _root.playHead._x = _root.progressBarStartX + (amountPlayed * _root.progressBarWidth);
        
    // Else playhead is dragging!
    } else {
        // See if playhead is dragging outside what is loaded, pull it back in if so - bit ugly/buggy
        /*
        var xPos = _root.playHead._x - 107;
        if (xPos > _root.loadBar._width) {
            _root.playHead._x = _root.loadBar._width + 107;
        }
        */

        // Calculate the duration, percentage of where this point is at
        var duration = _root.netStream.totalTime;
        var percentage = (_root.playHead._x - 107) / _root.progressBarWidth;
    
        // Seek the correct time - from the NEXT point because it usually ends up too far back
        var seekTime = duration * percentage;
        if (seekTime < 0) {
            seekTime = 0;
        }
        _root.netStream.seek(seekTime);
        
        //trace("Scrubbing playhead at: " + _root.playHead._x + ", percentage: " + percentage + ", seeking: " + seekTime);
    }
    
    // Update volume if its being scrolled
    if (_root.volumeInDrag) {
        // note: xpos of 2 = 0%, 73 = 100%
        var xPos = _root.volumeMC.volumeSlider._x;
        var percentage = (xPos - _root.volumeBarStartX) / _root.volumeBarWidth * 100;
        _root.flv_audio.setVolume(percentage);
        trace("xpos: " + xPos + " %: " + percentage);
    }
}

// Update the current sample array with the new sample value
function streamSample(val) {
	_root.samplesArray[_root.samplesIndex] = val;
	_root.samplesIndex++;
	if(_root.samplesIndex == _root.numberOfSamples) {
		_root.samplesIndex = 0;
	}
}

// Find the average kbps of the sample array
function sampleAverage() {
	var total = 0;
	for (i = 0; i < _root.numberOfSamples ; i++) {
		total += _root.samplesArray[i];
	}
	total = total / _root.numberOfSamples;
	return total;
}

// Convert time value to minutes
function convertToMinutes(val) {
    var min;
    var sec;
    var tmp;
    
    min = Math.floor(val/60);
    sec = Math.floor(val -(min*60));
    
    if (min < 10) {
        tmp = "0"+min.toString();
    } else {
        tmp = min.toString();
    }
    tmp = tmp + ":";
    if (sec < 10) {
        tmp = tmp + "0" + sec.toString();
    } else {
        tmp = tmp + sec.toString();
    }
    
    return tmp;
}


// Pause button
function pauseClick() {
    // Currently pause only ever pauses - never unpauses
    if (_root.playState == "playing") {
        _root.playState = "paused";
        _root.playButtonMC.gotoAndStop("off");
        _root.pauseButtonMC.gotoAndStop("on");
        trace("Paused1");
    } else {
        _root.playState = "paused";
        trace("Paused2");
    }
    _root.netStream.pause(true);
}


// Play button
function playClick() {
    // Currently play only ever plays - never pauses
    if (_root.playState == "playing") {
        _root.netStream.pause(false);
        _root.playState = "playing";
        trace("Playing1");
    } else {
        _root.netStream.pause(false);
        _root.playState = "playing";
        _root.playButtonMC.gotoAndStop("on");
        _root.pauseButtonMC.gotoAndStop("off");
        trace("Playing2");
    }
}


// Mouse release (stop dragging playhead amongst other functions)
_root.onMouseUp = function() {
    // If we were seeking, unpause the clip
    if (_root.playheadInDrag) {
        if (_root.playState == "wasPlaying") { //- If we were dragging when we were previously playing
            _root.netStream.pause();
            _root.playState = "playing";
        }
    }

    _root.playheadInDrag = false;
    _root.volumeInDrag = false;
    _root.playHead.stopDrag();
}

// Volume dragging
_root.beginVolumeDrag = function() {
    // Activate volume dragging
    _root.volumeInDrag = true;
    trace("volume slider hit");
}

// Volume bar click jump to
function volumeJump(xClick) {
    // Factor in xClicks location in its clip - range it 0-73 as per current locations
    xClick = xClick - _root.volumeMC._x;
    if (xClick < 0) {
        xClick = 0;
    } else if (xClick > _root.volumeBarWidth + _root.volumeBarStartX) {
        xClick = _root.volumeBarWidth + _root.volumeBarStartX;
    }
    
    // Calculate the percentage of where this point is at
    var percentage = xClick / (_root.volumeBarStartX + _root.volumeBarWidth) * 100;
    _root.flv_audio.setVolume(percentage);
    
    // Move volume head
    _root.volumeMC.volumeSlider._x = _root.volumeBarStartX + (_root.volumeBarWidth * percentage/100);
    trace("xclick: " + xClick + " %: " + percentage);
}

// Playhead scrubbing
_root.beginVideoScrub = function() {
    // Activate scrubbing
    _root.playheadInDrag = true;
    if (_root.playState == "playing") {
        _root.netStream.pause();
        _root.playState = "wasPlaying"; //- we were playing before dragging
    }
    trace("playhead hit, dragging!");
}

// Playbar click jump to
function playbarJump(xClick) {
    // Correct for 10px subtraction to centre the playhead
    xClick = xClick - 10;
    if (xClick < 107) {
        xClick = 107;
    } else if (xClick > 492) {
        xClick = 492;
    }
    
    // Calculate the duration, time, percentage of where this point is at
    var duration = _root.netStream.totalTime;
    var percentage = (xClick - 107) / _root.progressBarWidth;

    // Seek the correct time - from the NEXT point because it usually ends up too far back
    var seekTime = duration * percentage + 1;
    if (seekTime < 0) {
        seekTime = 0;
    }
    _root.netStream.seek(seekTime);
    
    trace("Playhead request xclick: " + xClick + ", percentage: " + percentage + ", seeking: " + seekTime);
}



//---- BEGIN PLAYBACK
if (_root.file) {
    clipToLoad = _root.file;
} else {
    clipToLoad = "ninja-200.flv";
    //clipToLoad = "http://www.switch.tv/content/ninja-200.flv";
}
_root.loadVideo(clipToLoad);